/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.transport;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.ExecutionException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.ReadResult;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.asyncqueue.MessageCloner;
import org.glassfish.grizzly.asyncqueue.WritableMessage;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.nio.transport.TCPNIOConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;

public final class TCPNIOTransportFilter
extends BaseFilter {
    private final TCPNIOTransport transport;

    TCPNIOTransportFilter(TCPNIOTransport transport) {
        this.transport = transport;
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Buffer buffer;
        TCPNIOConnection connection = (TCPNIOConnection)ctx.getConnection();
        boolean isBlocking = ctx.getTransportContext().isBlocking();
        Buffer inBuffer = (Buffer)ctx.getMessage();
        if (!isBlocking) {
            buffer = this.transport.read(connection, inBuffer);
        } else {
            GrizzlyFuture<ReadResult<Buffer, SocketAddress>> future = this.transport.getTemporarySelectorIO().getReader().read(connection, inBuffer);
            try {
                ReadResult result2 = (ReadResult)future.get();
                buffer = (Buffer)result2.getMessage();
                future.recycle(true);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                throw new IOException(cause);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
        if (buffer == null || buffer.position() == 0) {
            return ctx.getStopAction();
        }
        buffer.trim();
        ctx.setMessage(buffer);
        ctx.setAddressHolder(connection.peerSocketAddressHolder);
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        WritableMessage message = (WritableMessage)ctx.getMessage();
        if (message != null) {
            ctx.setMessage(null);
            Connection connection = ctx.getConnection();
            FilterChainContext.TransportContext transportContext = ctx.getTransportContext();
            CompletionHandler completionHandler = transportContext.getCompletionHandler();
            MessageCloner cloner = transportContext.getMessageCloner();
            transportContext.setCompletionHandler(null);
            transportContext.setMessageCloner(null);
            if (!transportContext.isBlocking()) {
                this.transport.getAsyncQueueIO().getWriter().write((Connection<SocketAddress>)connection, null, message, (CompletionHandler<WriteResult<WritableMessage, SocketAddress>>)completionHandler, cloner);
            } else {
                this.transport.getTemporarySelectorIO().getWriter().write(connection, null, message, completionHandler);
            }
        }
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
        if (event.type() == TransportFilter.FlushEvent.TYPE) {
            Connection connection = ctx.getConnection();
            FilterChainContext.TransportContext transportContext = ctx.getTransportContext();
            if (transportContext.getCompletionHandler() != null) {
                throw new IllegalStateException("TransportContext CompletionHandler must be null");
            }
            CompletionHandler completionHandler = ((TransportFilter.FlushEvent)event).getCompletionHandler();
            this.transport.getWriter(transportContext.isBlocking()).write((Connection<SocketAddress>)connection, Buffers.EMPTY_BUFFER, completionHandler);
        }
        return ctx.getInvokeAction();
    }

    @Override
    public void exceptionOccurred(FilterChainContext ctx, Throwable error2) {
        Connection connection = ctx.getConnection();
        if (connection != null) {
            connection.closeSilently();
        }
    }
}

